/*
 * Decompiled with CFR 0.152.
 */
package org.echolink.proxy;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.echolink.proxy.ELProxy;

public class ProxyMessage {
    public static final int PROXY_MSG_FIRST = 1;
    public static final int PROXY_MSG_TCP_OPEN = 1;
    public static final int PROXY_MSG_TCP_DATA = 2;
    public static final int PROXY_MSG_TCP_CLOSE = 3;
    public static final int PROXY_MSG_TCP_STATUS = 4;
    public static final int PROXY_MSG_UDP_DATA = 5;
    public static final int PROXY_MSG_UDP_CONTROL = 6;
    public static final int PROXY_MSG_SYSTEM = 7;
    public static final int PROXY_MSG_LAST = 7;
    private static final int HEADER_SIZE = 9;
    private static final int MAX_DATA_SIZE = 5000;
    private int m_nType;
    private InetAddress m_aAddress;
    private int m_nSize;
    private byte[] m_bData;

    public ProxyMessage() {
        this.m_nType = 0;
        this.m_aAddress = null;
        this.m_nSize = 0;
        this.m_bData = null;
    }

    public ProxyMessage(int nType, InetAddress aAddress, int nSize, byte[] bData) {
        this.m_nType = nType;
        this.m_aAddress = aAddress;
        this.m_nSize = nSize;
        this.m_bData = bData;
    }

    public int getType() {
        return this.m_nType;
    }

    public int getSize() {
        return this.m_nSize;
    }

    public InetAddress getAddress() {
        return this.m_aAddress;
    }

    public byte[] getData() {
        return this.m_bData;
    }

    public static ProxyMessage readFromSocket(Socket s) throws IOException {
        ProxyMessage cMsg = null;
        InputStream stm = s.getInputStream();
        byte[] bufHeader = new byte[9];
        int nLenRemaining = 9;
        int nOffset = 0;
        while (nLenRemaining > 0) {
            int nRead = stm.read(bufHeader, nOffset, nLenRemaining);
            if (nRead < 0) {
                throw new IOException("stm.read() returned EOF");
            }
            nLenRemaining -= nRead;
            nOffset += nRead;
        }
        ByteBuffer bb = ByteBuffer.wrap(bufHeader);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte nType = bb.get();
        if (nType < 1 || nType > 7) {
            throw new IOException("Unrecognized message type in client request");
        }
        byte[] bAddr = new byte[]{bb.get(), bb.get(), bb.get(), bb.get()};
        int nSize = bb.getInt();
        if (nSize > 5000) {
            throw new IOException("Message data too large in client request (" + nSize + " bytes)");
        }
        InetAddress aAddress = InetAddress.getByAddress(bAddr);
        byte[] bData = null;
        if (nSize > 0) {
            bData = new byte[nSize];
            nLenRemaining = nSize;
            nOffset = 0;
            while (nLenRemaining > 0) {
                int nRead = stm.read(bData, nOffset, nLenRemaining);
                if (nRead < 0) {
                    throw new IOException("stm.read() returned EOF");
                }
                nLenRemaining -= nRead;
                nOffset += nRead;
            }
        }
        ELProxy.traceMsg("Read from client: type=" + nType + ", size=" + nSize);
        cMsg = new ProxyMessage(nType, aAddress, nSize, bData);
        return cMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToSocket(Socket s) throws IOException {
        if (s == null) {
            return;
        }
        byte[] bufHeader = new byte[9];
        ByteBuffer bb = ByteBuffer.wrap(bufHeader);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put((byte)this.m_nType);
        byte[] bAddr = null;
        if (this.m_aAddress != null) {
            bAddr = this.m_aAddress.getAddress();
        } else {
            bAddr = new byte[4];
            bAddr[3] = 0;
            bAddr[2] = 0;
            bAddr[1] = 0;
            bAddr[0] = 0;
        }
        bb.put(bAddr);
        bb.putInt(this.m_nSize);
        Socket socket = s;
        synchronized (socket) {
            BufferedOutputStream stm = new BufferedOutputStream(s.getOutputStream(), 9 + this.m_nSize);
            stm.write(bufHeader);
            if (this.m_nSize > 0) {
                stm.write(this.m_bData, 0, this.m_nSize);
            }
            stm.flush();
        }
        ELProxy.traceMsg("Sent to client: type=" + this.m_nType + ", size=" + this.m_nSize);
    }
}

