/*
 * Decompiled with CFR 0.152.
 */
package org.echolink.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.echolink.proxy.ELProxy;
import org.echolink.proxy.ProxyMessage;

public class TCPListener
extends Thread {
    private InputStream m_stm;
    private Socket m_sClient;

    public TCPListener(Socket sClient, Socket sListen) throws IOException {
        this.m_sClient = sClient;
        this.m_stm = sListen.getInputStream();
    }

    public void run() {
        while (true) {
            byte[] bData = new byte[4096];
            try {
                int nRead = this.m_stm.read(bData);
                if (nRead < 0) {
                    throw new IOException("Remote server closed socket");
                }
                ELProxy.traceMsg("TCPListener: received " + nRead + " bytes");
                ProxyMessage cMsg = new ProxyMessage(2, null, nRead, bData);
                try {
                    cMsg.writeToSocket(this.m_sClient);
                }
                catch (IOException e2) {
                }
            }
            catch (IOException e) {
                ELProxy.traceMsg("TCPListener: " + e.toString());
                ProxyMessage cMsgClose = new ProxyMessage(3, null, 0, null);
                try {
                    cMsgClose.writeToSocket(this.m_sClient);
                    break;
                }
                catch (IOException e3) {
                    break;
                }
            }
        }
        ELProxy.traceMsg("TCPListener exiting");
    }
}

