/*
 * Decompiled with CFR 0.152.
 */
package org.echolink.proxy;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import org.echolink.proxy.ELProxy;
import org.echolink.proxy.ProxyMessage;

public class UDPListener
extends Thread {
    private Socket m_sClient = null;
    private DatagramSocket m_sListen;
    private int m_nType;
    private boolean m_fAbort;

    public UDPListener(int nType, DatagramSocket sListen) {
        this.m_sListen = sListen;
        this.m_nType = nType;
        this.m_fAbort = false;
    }

    public void signalStop() {
        this.m_fAbort = true;
    }

    public void setReplySocket(Socket s) {
        this.m_sClient = s;
    }

    public void run() {
        ELProxy.traceMsg("UDPListener started (type=" + this.m_nType + ")");
        byte[] buf = new byte[1500];
        while (!this.m_fAbort) {
            try {
                DatagramPacket dp = new DatagramPacket(buf, 1500);
                this.m_sListen.receive(dp);
                if (this.m_sClient == null) continue;
                InetAddress addrSource = dp.getAddress();
                byte[] bData = dp.getData();
                ProxyMessage cMsg = new ProxyMessage(this.m_nType, addrSource, dp.getLength(), bData);
                if (this.m_sClient == null) continue;
                cMsg.writeToSocket(this.m_sClient);
            }
            catch (Throwable throwable) {}
        }
        ELProxy.traceMsg("UDPListener exiting");
    }
}

